<?xml version="1.0" encoding="UTF-8"?>
<!-- El objetivo de este archivo SLD, es el de simbolizar la entidad urbanística correspondiente según lo indicado en la "Instrucción técnica de estandarización y normalización de instrumentos de planeamiento (ITU-PL1)". Antes de su uso deberá revisar las etiquetas que hacen referencia a los campos existentes en las tablas de datos, especialmente los destinados a simbolizar por categorías, los de elementos alfanuméricos y los de geometría. Su definición puede admitir variantes y ser mejorada. Si es el caso, por favor, comparta su conocimiento para que futuros usuarios puedan beneficiarse. Gracias. | Murcia, mayo de 2024 | SERVICIO DE URBANISMO | https://www.urbmurcia.es/web/urbmurcia/contacto | -->
<sld:StyledLayerDescriptor xmlns="http://www.opengis.net/sld" xmlns:sld="http://www.opengis.net/sld" xmlns:gml="http://www.opengis.net/gml" xmlns:ogc="http://www.opengis.net/ogc" version="1.0.0">
	<sld:NamedLayer>
		<sld:Name>_15_elem_catalogados_area</sld:Name>
		<sld:UserStyle>
			<sld:Name>_15_elem_catalogados_area</sld:Name>
			<sld:FeatureTypeStyle>
				<sld:Name>name</sld:Name>
				<sld:Rule>
					<sld:Name>Catálogo cultural</sld:Name>
					<ogc:Filter>
						<ogc:PropertyIsLike wildCard="%" singleChar="_" escape="\">
							<ogc:PropertyName>Código</ogc:PropertyName>
							<ogc:Literal>B%</ogc:Literal>
						</ogc:PropertyIsLike>
					</ogc:Filter>
					<sld:LineSymbolizer>
						<sld:Geometry>
							<ogc:PropertyName>geom2</ogc:PropertyName>
						</sld:Geometry>
						<sld:Stroke>
							<sld:CssParameter name="stroke">#78503C</sld:CssParameter>
							<sld:CssParameter name="stroke-dasharray">6.0 3.0 1.0 3.0 1.0 3.0</sld:CssParameter>
						</sld:Stroke>
					</sld:LineSymbolizer>
				</sld:Rule>
				<sld:Rule>
					<sld:Name>Catálogo Natural</sld:Name>
					<ogc:Filter>
						<ogc:PropertyIsLike wildCard="%" singleChar="_" escape="\">
							<ogc:PropertyName>Código</ogc:PropertyName>
							<ogc:Literal>Y%</ogc:Literal>
						</ogc:PropertyIsLike>
					</ogc:Filter>
					<sld:LineSymbolizer>
						<sld:Geometry>
							<ogc:PropertyName>geom2</ogc:PropertyName>
						</sld:Geometry>
						<sld:Stroke>
							<sld:CssParameter name="stroke">#78A050</sld:CssParameter>
							<sld:CssParameter name="stroke-dasharray">6.0 3.0 1.0 3.0 1.0 3.0</sld:CssParameter>
						</sld:Stroke>
					</sld:LineSymbolizer>
				</sld:Rule>
				<sld:Rule>
					<ogc:Filter>
						<ogc:PropertyIsLike wildCard="%" singleChar="_" escape="\">
							<ogc:PropertyName>Código</ogc:PropertyName>
							<ogc:Literal>B%</ogc:Literal>
						</ogc:PropertyIsLike>
					</ogc:Filter>
					<sld:TextSymbolizer>
						<sld:Label>
							<ogc:PropertyName>Código</ogc:PropertyName>
						</sld:Label>
						<sld:Font>
							<sld:CssParameter name="font-family">Liberation Mono</sld:CssParameter>
							<sld:CssParameter name="font-size">12</sld:CssParameter>
							<sld:CssParameter name="font-style">normal</sld:CssParameter>
							<sld:CssParameter name="font-weight">normal</sld:CssParameter>
						</sld:Font>
						<sld:LabelPlacement>
							<sld:PointPlacement>
								<sld:AnchorPoint>
									<sld:AnchorPointX>0.5</sld:AnchorPointX>
									<sld:AnchorPointY>0.5</sld:AnchorPointY>
								</sld:AnchorPoint>
								<sld:Displacement>
									<sld:DisplacementX>0.5</sld:DisplacementX>
									<sld:DisplacementY>0.5</sld:DisplacementY>
								</sld:Displacement>
							</sld:PointPlacement>
						</sld:LabelPlacement>
						<sld:Fill>
							<sld:CssParameter name="fill">#78503C</sld:CssParameter>
						</sld:Fill>
					</sld:TextSymbolizer>
				</sld:Rule>
				<sld:Rule>
					<ogc:Filter>
						<ogc:PropertyIsLike wildCard="%" singleChar="_" escape="\">
							<ogc:PropertyName>Código</ogc:PropertyName>
							<ogc:Literal>Y%</ogc:Literal>
						</ogc:PropertyIsLike>
					</ogc:Filter>
					<sld:TextSymbolizer>
						<sld:Label>
							<ogc:PropertyName>Código</ogc:PropertyName>
						</sld:Label>
						<sld:Font>
							<sld:CssParameter name="font-family">Liberation Mono</sld:CssParameter>
							<sld:CssParameter name="font-size">12</sld:CssParameter>
							<sld:CssParameter name="font-style">normal</sld:CssParameter>
							<sld:CssParameter name="font-weight">normal</sld:CssParameter>
						</sld:Font>
						<sld:LabelPlacement>
							<sld:PointPlacement>
								<sld:AnchorPoint>
									<sld:AnchorPointX>0.0</sld:AnchorPointX>
									<sld:AnchorPointY>0.5</sld:AnchorPointY>
								</sld:AnchorPoint>
								<sld:Displacement>
									<sld:DisplacementX>0.0</sld:DisplacementX>
									<sld:DisplacementY>0.0</sld:DisplacementY>
								</sld:Displacement>
							</sld:PointPlacement>
						</sld:LabelPlacement>
						<sld:Fill>
							<sld:CssParameter name="fill">#78A050</sld:CssParameter>
						</sld:Fill>
						<sld:VendorOption name="maxDisplacement">1</sld:VendorOption>
					</sld:TextSymbolizer>
				</sld:Rule>
			</sld:FeatureTypeStyle>
		</sld:UserStyle>
	</sld:NamedLayer>
</sld:StyledLayerDescriptor>